-- File generated with srec2prom.exe  DO NOT EDIT THIS FILE!
-- Copyright (C) 2019  Dr. Uwe Meyer-Baese.
-- =======================================================
LIBRARY ieee;
USE ieee.STD_LOGIC_1164.ALL;
USE ieee.STD_LOGIC_arith.ALL;
USE ieee.STD_LOGIC_unsigned.ALL;
-- =======================================================
ENTITY rom4096x32 IS
PORT (clk   : IN STD_LOGIC;      -- System clock
      reset : IN STD_LOGIC;      -- Asynchronous reset
      pma   : IN STD_LOGIC_VECTOR(11 DOWNTO 0); -- Program memory address
      pmd   : OUT STD_LOGIC_VECTOR(31 DOWNTO 0)); -- Program memory data
END ENTITY rom4096x32;
-- =======================================================
ARCHITECTURE fpga OF rom4096x32 IS
-- Program ROM definition and values
TYPE MEMP IS ARRAY (0 TO 4095) OF STD_LOGIC_VECTOR(31 DOWNTO 0);
CONSTANT prom : MEMP := (
X"06CF_F014", --        ori     sp, r0, 0x3FC0  /* initial stack pointer */
X"0682_2B14", --        ori     gp, r0, 0x08AC  /* initial global pointer */
X"0601_EC14", --        ori     et, r0, 0x07B0  /* initial et pointer */       
X"0080_0514", --        ori     r2, r0, 0x0014  /* set main entry */        
X"1000_683A", --        jmp     r2
X"0080_0044", -- main: addi    r2, zero, 0x1     /* s=1 */
X"D880_0035", --       stwio   r2, 0(sp)         /* store s */
X"0080_0084", --       addi    r2, zero, 0x2     /* g=2 */
X"D080_0035", --       stwio   r2, 0(gp)         /* store g */
X"D880_0037", --       ldwio   r2, 0(sp)         /* load s */
X"D880_0135", --       stwio   r2, 4(sp)         /* store sarray[0] */
X"D080_0037", --       ldwio   r2, 0(gp)         /* load g */
X"18C2_2C04", --       addi    r3, r3, 0x8B0     /* address garray[0] */
X"1880_0035", --       stwio   r2, 0(r3)         /* garray[0]=g */
X"D880_0037", --       ldwio   r2, 0(sp)         /* load s */
X"1085_883A", --       add     r2, r2, r2        /* s*2 */
X"1085_883A", --       add     r2, r2, r2        /* s*4 */
X"D885_883A", --       add     r2, sp, r2        /* s*4+sp */
X"1080_0104", --       addi    r2, r2, 0x4       /* s*4+sp+4 = &sarray[s]*/
X"0104_D5C4", --       addi    r4, zero, 0x1357  /* =0x1357  */
X"1100_0035", --       stwio   r4, 0(r2)         /* store sarray[s] */
X"D080_0037", --       ldwio   r2, 0(gp)         /* load g */
X"1085_883A", --       add     r2, r2, r2        /* g*2 */
X"1085_883A", --       add     r2, r2, r2        /* g*4 */
X"1885_883A", --       add     r2, r3, r2        /* g*4+&garray[0] */
X"0109_1A04", --       addi    r4, zero, 0x2468  /* =0x2468 */
X"1100_0035", --       stwio   r4, 0(r2)         /* store garray[g] */
X"003F_E906", --       br       main             /* start loop again */
OTHERS => X"00000001"); -- default jump to 0

BEGIN
-- The following process will be mapped to a BlockRAM for Zynq/Virtex/Spartan
-- devices (if addr > 4 bit!) and to Distributed RAM in all other cases

prog_rom: PROCESS (reset, clk)
BEGIN
  IF reset = '0' THEN               -- Asynchronous clear
    pmd <= (OTHERS => '0');     
  ELSIF rising_edge(clk) THEN
      pmd <= prom(CONV_INTEGER(pma)); -- Read from ROM
  END IF;
END PROCESS;

END ARCHITECTURE fpga;
